package dms;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import flex.data.ChangeObject;
import flex.data.DataSyncException;

public class SandwichAssembler
{

	public List loadSandwiches()
	{
		SandwichDAO dao = new SandwichDAO();
		return dao.getSandwiches();
	}

	public List loadSandwiches(String name)
	{
		SandwichDAO dao = new SandwichDAO();
		return dao.getSandwiches(name);
	}

	public Sandwich getSandwich(Map uid)
	{
		SandwichDAO dao = new SandwichDAO();
		return dao.getSandwich(((Integer) uid.get("sandwichId")).intValue());
	}

	public List syncSandwiches(List changes)
	{
		Iterator iterator = changes.iterator();
		ChangeObject co;
		while (iterator.hasNext())
		{
			co = (ChangeObject) iterator.next();
			if (co.isCreate())
			{
				co = doCreate(co);
			}
			else if (co.isUpdate())
			{
				doUpdate(co);
			}
			else if (co.isDelete())
			{
				doDelete(co);
			}
		}
		return changes;
	}

	private ChangeObject doCreate(ChangeObject co)
	{
		SandwichDAO dao = new SandwichDAO();
		Sandwich sandwich = dao.create((Sandwich) co.getNewVersion());
		co.setNewVersion(sandwich);
		return co;
	}

	private void doUpdate(ChangeObject co)
	{
		SandwichDAO dao = new SandwichDAO();
		try
		{
			dao.update((Sandwich) co.getNewVersion(), (Sandwich) co.getPreviousVersion());
		}
		catch (ConcurrencyException e)
		{
			System.err.println("*** Throwing DataSyncException when trying to update contact id=" + ((Sandwich) co.getNewVersion()).getSandwichId() );
			throw new DataSyncException(co);
		}
	}

	private void doDelete(ChangeObject co)
	{
		SandwichDAO dao = new SandwichDAO();
		try
		{
			dao.delete((Sandwich) co.getPreviousVersion());
		}
		catch (ConcurrencyException e)
		{
			System.err.println("*** Throwing DataSyncException when trying to delete sandwich id=" + ((Sandwich) co.getNewVersion()).getSandwichId() );
			throw new DataSyncException(co);
		}
		
	}

}