package fstop;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.net.URLDecoder;

public class ConnectionHelper
{

	private String url;

	private static ConnectionHelper instance;

	public String getUrl()
	{
		return url;
	}

	private ConnectionHelper()
	{
		try
		{
			Class.forName("org.hsqldb.jdbcDriver");
			// Obtain a path to WEB-INF/classes/f2ria/sandwich
			String str = URLDecoder.decode(getClass().getClassLoader().getResource("fstop").toString(),"UTF-8");
			System.out.println(str);
			// Create HSQLDB JDBC URL pointing to WEB-INF/db/sandwich/sandwich (where the last sandwich is the database name)
			url = "jdbc:hsqldb:" + str.substring(0, str.indexOf("classes/fstop")) + "db/photos/photos";
			System.out.println("url: " + url);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public static ConnectionHelper getInstance()
	{
		if (instance == null)
			instance = new ConnectionHelper();
		return instance;
	}

	public static Connection getConnection() throws java.sql.SQLException
	{
		return DriverManager.getConnection(getInstance().getUrl());
	}

	public static void closeConnection(Connection c)
	{
		try
		{
			if (c != null)
			{
			    c.close();
            }
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}

}
