package rorpc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SandwichDAO
{
	public List getSandwiches() throws DAOException
	{
		System.out.println("executing SandwichDAO.getSandwiches");

		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT * FROM sandwich ORDER BY sandwichName");
			Sandwich sandwich;
			while (rs.next())
			{
				sandwich = new Sandwich();
				sandwich.setSandwichId(rs.getInt("sandwich_id"));
				sandwich.setSandwichName(rs.getString("sandwichName"));
				sandwich.setBread(rs.getString("bread"));
				sandwich.setMeat(rs.getString("meat"));
				sandwich.setSpread(rs.getString("spread"));
				sandwich.setType(rs.getString("type"));
				list.add(sandwich);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

		return list;
	}

	public List getSandwiches(String type) throws DAOException
	{
		System.out.println("executing SandwichDAO.getSandwiches(String)");

		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();

			PreparedStatement ps = c.prepareStatement("SELECT * FROM sandwich WHERE type = ?"
					+ " ORDER BY sandwichName");
			ps.setString(1, type);
			ResultSet rs = ps.executeQuery();

			Sandwich sandwich;
			while (rs.next())
			{
				sandwich = new Sandwich();
				sandwich.setSandwichId(rs.getInt("sandwich_id"));
				sandwich.setSandwichName(rs.getString("sandwichName"));
				sandwich.setBread(rs.getString("bread"));
				sandwich.setMeat(rs.getString("meat"));
				sandwich.setSpread(rs.getString("spread"));
				sandwich.setType(rs.getString("type"));
				list.add(sandwich);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		return list;
	}

	public Sandwich getSandwich(int sandwichId) throws DAOException
	{

		Sandwich sandwich = null;
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT * FROM sandwich WHERE sandwich_id="
					+ sandwichId);
			if (rs.next())
			{
				sandwich = new Sandwich();
				sandwich.setSandwichId(rs.getInt("sandwich_id"));
				sandwich.setSandwichName(rs.getString("sandwichName"));
				sandwich.setBread(rs.getString("bread"));
				sandwich.setMeat(rs.getString("meat"));
				sandwich.setSpread(rs.getString("spread"));
				sandwich.setType(rs.getString("type"));
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		System.out.println("sandwich get " + sandwich);
		return sandwich;
	}

	/**
	 * * Returns a List of Strings
	 * @return List
	 * @throws DAOException
	 */
	public List getAllTypes() throws DAOException {
		ArrayList list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery("SELECT DISTINCT type FROM sandwich ORDER BY type");
			while (rs.next())
			{
				list.add(rs.getString("type"));
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

		return list;
	}

	public Sandwich create(Sandwich sandwich) throws DAOException
	{

		validate(sandwich);

		System.out.println("executing SandwichDAO.create: " + sandwich);

		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			PreparedStatement ps = c.prepareStatement(
				"INSERT INTO sandwich " +
				"(sandwichName, bread, meat, spread, type) " +
				"VALUES (?, ?, ?, ?, ?)");
			ps.setString(1, sandwich.getSandwichName());
			ps.setString(2, sandwich.getBread());
			ps.setString(3, sandwich.getMeat());
			ps.setString(4, sandwich.getSpread());
			ps.setString(5, sandwich.getType());
			ps.execute();
			Statement s = c.createStatement();
			// HSQLDB Syntax to get the identity (sandwichId) of inserted row
			ResultSet rs = s.executeQuery("CALL IDENTITY()");
			rs.next();
			sandwich.setSandwichId(rs.getInt(1));
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		return sandwich;
	}

	public void update(Sandwich sandwich) throws DAOException
	{

		validate(sandwich);

		System.out.println("executing SandwichDAO.update: " + sandwich);

		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
            PreparedStatement ps = c.prepareStatement("UPDATE sandwich SET sandwichName=?, bread=?, meat=?, spread=?, type=? " +
            		"WHERE sandwich_id=?");
            ps.setString(1, sandwich.getSandwichName());
            ps.setString(2, sandwich.getBread());
            ps.setString(3, sandwich.getMeat());
            ps.setString(4, sandwich.getSpread());
            ps.setString(5, sandwich.getType());
            ps.setInt(6, sandwich.getSandwichId());
			if (ps.executeUpdate() == 0)
			{
				throw new RuntimeException("Sandwich ID not found");
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

	}

	public void delete(int sandwichId) throws DAOException
	{
		System.out.println("executing SandwichDAO.delete: "+ sandwichId);

		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			PreparedStatement ps = c.prepareStatement("DELETE FROM sandwich WHERE sandwich_id=?");
			ps.setInt(1, sandwichId);
			if (ps.executeUpdate() == 0)
			{
				throw new RuntimeException("Item not found");
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new DAOException(e.getMessage());
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}

	}

	private void validate(Sandwich sandwich) {
		if (sandwich.getSandwichName() == null ||
			sandwich.getSandwichName().length() == 0) {
			System.err.println("Validation error on sandwichName");
			throw new ValidationException("Sandwich name can't be blank",
				"sandwich");
		}
	}


}