package services;

/*
 * Created on 3/31/2006
 *
 * SimpleService class demonstrates service
 * Flex training app
 */

/**
 *@author David Gassner, extended from code by Robert Crooks, Matthew Boles
 *
 * simple service for Flex 2 client
 * can be called as either web service or remote object service
 */

import java.util.HashMap;
import java.util.Map;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SimpleService {

	// properties
	private String helloString="Hello from a Simple Service!";
	private Map[] menuInfo = new HashMap[2];

	// constructors
	public SimpleService() {}

	//methods
	
	/**
	 *A method that returns a simple string
 	 */
	public String outMethod()
	{
		return helloString;
	}

	/**
	 *A method that returns static complex data
	 */ 
	public Map[] arrayOutMethod()
	{
		Map menu1=new HashMap();
		Map menu2=new HashMap();
		menu1.put("starter","Smoked Salmon");
		menu1.put("main","Filet");
		menu1.put("dessert","Key Lime Pie");
		menu2.put("starter","Calamari");
		menu2.put("main","Curried Lamb");
		menu2.put("dessert","Berry Pie");
		menuInfo[0]=menu1;
		menuInfo[1]=menu2;
		return menuInfo;
	}
	
	/**
	 *A method that received 2 Strings and returns a concatenated String
	 */ 
	public String multArgsMethod(String oneArg, String twoArg)
	{
		return ("The String arguments are: " + oneArg + 
				" and " + twoArg );
	}
	
	/**
	 * A method that returns data retrieved dynamically from a database
	 */
	public List getSandwichList() throws Exception
	{
		List list = new ArrayList();
		Connection c = null;
		try
		{
			c = ConnectionHelper.getConnection();
			Statement s = c.createStatement();
			ResultSet rs = s.executeQuery(
				"SELECT sandwichName,bread,meat,spread,type FROM sandwich");
			Map sandwich;
			while (rs.next())
			{
				sandwich = new HashMap();
				sandwich.put("sandwichName", rs.getString("sandwichName"));
				sandwich.put("bread", rs.getString("bread"));
				sandwich.put("meat", rs.getString("meat"));
				sandwich.put("spread", rs.getString("spread"));
				sandwich.put("type", rs.getString("type"));
				list.add(sandwich);
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			ConnectionHelper.closeConnection(c);
		}
		return list;
		
	}
}
