// ActionScript file for Contribute.mxml
import events.PhotoEvent;

import flash.net.FileFilter;
import flash.net.FileReference;
import flash.net.URLRequest;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.validators.Validator;

import valueObjects.Photo;

[Bindable]
public var categoryData:ArrayCollection;
private var fileRef:FileReference;
private var fileBrowsed:Boolean=false;

private function init():void 
{
	fileRef = new FileReference();
	fileRef.addEventListener(Event.SELECT, browseSelectHandler);
	fileRef.addEventListener(Event.COMPLETE, uploadCompleteHandler);
	resetForm();
}

public function resetForm():void 
{
	filename.text='';
	photographerInput.text='';
	descInput.text='';
	fileBrowsed=false;
}

private function browseForPhoto():void 
{
	fileRef.browse( [ new FileFilter('Images','*.jpg') ] );
}

private function browseSelectHandler(event:Event):void 
{
	fileBrowsed=true;
	filename.text=fileRef.name;
}

private function uploadFile():void 
{
	if (validateUpload()) 
	{
		var request:URLRequest = new URLRequest("ProcessFileUpload.jsp");
		trace("before upload");
		fileRef.upload(request);
		trace("after upload");
	}
}

private function uploadCompleteHandler(event:Event):void 
{	
	trace("upload complete");
	var photo:Photo = new Photo();
	photo.photographer=photographerInput.text;
	photo.desc=descInput.text;
	photo.filename=fileRef.name;
	photo.categoryId=categoryList.selectedItem.categoryId;
	var uploadEvent:PhotoEvent = new PhotoEvent(photo, "photoUploaded");
	dispatchEvent(uploadEvent);
}

private function validateUpload():Boolean 
{
	if (!fileBrowsed) 
	{
		Alert.show("Please select an image file to upload", "Error");
		return false;
	}
	else 
	{
		var invalidArray:Array = Validator.validateAll([photographerValidator, descValidator]);
		if (invalidArray.length != 0) 
		{
			Alert.show("There are form errors", "Error");
			return false;   
		}
		else 
		{
			return true;
		}
	} 
}
